# Logo Generator UI Guide

## Visual Layout

```
┌─────────────────────────────────────────────────────────────────┐
│                         VYLO Header                              │
│  [Logo] VYLO                              [Back to Project]     │
└─────────────────────────────────────────────────────────────────┘

┌─────────────────────────────────────────────────────────────────┐
│  AI Logo Generator                                              │
│  Powered by DALL-E 3 - Create stunning logos in seconds        │
└─────────────────────────────────────────────────────────────────┘

┌──────────────────────────────┬─────────────────────────────────┐
│         FORM COLUMN          │        PREVIEW COLUMN           │
├──────────────────────────────┼─────────────────────────────────┤
│                              │                                 │
│  Company Name *              │         Preview                 │
│  [Input Field_________]      │   ┌─────────────────────────┐   │
│                              │   │                         │   │
│  Logo Style *                │   │   [Animated Gradient]   │   │
│  ┌────┬────┬────┬────┐       │   │                         │   │
│  │🚀  │⚡  │🎩  │🎨  │       │   │    [Generated Logo]     │   │
│  │Mod.│Min.│Vin.│Play│       │   │         or              │   │
│  └────┴────┴────┴────┘       │   │   [Loading Spinner]     │   │
│  ┌────┬────┬────┬────┐       │   │         or              │   │
│  │💼  │🌀  │📐  │🌿  │       │   │    [Empty State]        │   │
│  │Pro.│Abs.│Geo.│Org.│       │   │                         │   │
│  └────┴────┴────┴────┘       │   └─────────────────────────┘   │
│                              │                                 │
│  Colors * (max 5)            │   ┌─────────────────────────┐   │
│  [Tech] [Nature] [Fire]...   │   │  [Download] [Save]      │   │
│  ┌──┬──┬──┬──┬──────┐        │   │  [Generate Another]     │   │
│  │██│██│██│██│[+Add]│        │   └─────────────────────────┘   │
│  └──┴──┴──┴──┴──────┘        │                                 │
│                              │   ┌─────────────────────────┐   │
│  Industry (Optional)         │   │  💡 Pro Tips:           │   │
│  [Input Field_________]      │   │  • Be specific          │   │
│                              │   │  • Match brand colors   │   │
│  Mood (Optional)             │   │  • Try different styles │   │
│  [Bold] [Elegant] [Friendly] │   └─────────────────────────┘   │
│  [Serious] [Innovative]...   │                                 │
│                              │                                 │
│  Additional Details          │                                 │
│  ┌────────────────────────┐  │                                 │
│  │ Textarea for extra     │  │                                 │
│  │ description...         │  │                                 │
│  └────────────────────────┘  │                                 │
│                              │                                 │
│  ┌────────────────────────┐  │                                 │
│  │   [Generate Logo]      │  │                                 │
│  └────────────────────────┘  │                                 │
│                              │                                 │
└──────────────────────────────┴─────────────────────────────────┘
```

## Color Scheme

### VYLO Brand Colors
- **Primary**: `#00f0ff` (Cyan)
- **Secondary**: `#ff00ff` (Magenta)
- **Accent**: `#7b2ff7` (Purple)
- **Success**: `#00ff88` (Green)
- **Warning**: `#ffaa00` (Orange)
- **Error**: `#ff0055` (Red)
- **Dark**: `#0a0a0f`
- **Darker**: `#050507`

### UI Elements
- Cards: Dark background with purple glow border
- Buttons: Gradient from accent to primary
- Inputs: Dark with purple accent border
- Text: White on dark background

## Interactive States

### Form Elements
1. **Default State**: Border with low opacity
2. **Hover State**: Border brightens, slight scale increase
3. **Active/Selected**: Full brightness border, glow effect
4. **Disabled**: Reduced opacity, no interactions

### Logo Generation Progress
1. **Idle**: Shows placeholder with emoji and instructions
2. **Generating**:
   - Spinning loader
   - Progress bar 0-100%
   - Status text updates
   - Animated background gradients
3. **Complete**:
   - Fade-in logo display
   - Action buttons appear
   - Success state

### Animations
- **Smooth Transitions**: 300ms ease-in-out
- **Hover Scale**: 1.02-1.05x
- **Glow Pulse**: 2s infinite alternate
- **Progress Bar**: 500ms width transition
- **Spinner**: Continuous rotation
- **Background**: Gradient pulse (4s)

## Responsive Breakpoints

### Desktop (lg: 1024px+)
- Two-column layout
- Full form controls visible
- Large preview area

### Tablet (md: 768px+)
- Two-column layout (narrower)
- Style grid 2x4
- Compact spacing

### Mobile (<768px)
- Single column stack
- Form on top, preview below
- Style grid 2x4
- Touch-optimized buttons

## Typography

### Headings
- Page Title: 4xl font-black
- Section: 2xl font-bold
- Card Title: xl font-bold
- Labels: sm font-semibold

### Body Text
- Normal: base regular
- Description: sm text-gray-400
- Tiny: xs text-gray-500

### Special
- Gradient Text: bg-clip-text with vylo gradient
- Monospace: font-mono for IDs

## Component Hierarchy

```
LogoGeneratorPage
├── Header
│   ├── Logo/Brand
│   └── Navigation
├── Page Header
│   ├── Title
│   └── Description
└── Main Grid
    ├── Form Column
    │   ├── Company Name Card
    │   ├── Style Selection Card
    │   ├── Color Selection Card
    │   ├── Industry/Mood Card
    │   ├── Description Card
    │   ├── Generate Button
    │   └── Error Display
    └── Preview Column
        ├── Preview Card
        │   ├── Animated Background
        │   ├── Content (Logo/Loading/Empty)
        │   └── Action Buttons
        └── Pro Tips Card
```

## Key Interactions

### 1. Style Selection
- Click any style card to select
- Selected card gets primary border and scale
- Only one style active at a time

### 2. Color Management
- Click preset to apply all colors
- Use color picker to select custom
- Click + Add to add custom color
- Hover color to show remove button
- Max 5 colors enforced

### 3. Mood Tags
- Click to toggle on/off
- Selected tags get primary background
- Multiple selections allowed
- Visual feedback immediate

### 4. Generation Flow
- Click Generate button
- Button shows loading state
- Progress bar appears and fills
- Status updates shown
- Logo fades in when ready
- Action buttons enable

### 5. Post-Generation
- Download: Direct file download
- Save to Project: Database save (TODO)
- Generate Another: Reset form

## Accessibility Features

- Semantic HTML elements
- Focus states on all interactive elements
- Disabled states clearly indicated
- Error messages descriptive
- Loading states announced
- Keyboard navigation support

## Performance Optimizations

- Client-side form validation
- Debounced API calls
- Optimistic UI updates
- Image lazy loading
- CSS transitions (GPU accelerated)
- Minimal re-renders with React hooks

---

This UI is designed to be intuitive, beautiful, and functional while maintaining VYLO's stunning dark aesthetic!
