import type { Metadata } from "next";
import { Inter } from "next/font/google";
import "./globals.css";

const inter = Inter({ subsets: ["latin"] });

export const metadata: Metadata = {
  title: "VYLO - AI-Powered Software Creation",
  description: "From Vision to Launch, on Autopilot. The ultimate AI-powered project management and software creation platform.",
  keywords: ["AI", "project management", "software development", "automation", "SaaS"],
};

export default function RootLayout({
  children,
}: Readonly<{
  children: React.Node;
}>) {
  return (
    <html lang="en" className="dark">
      <body className={inter.className}>
        {children}
      </body>
    </html>
  );
}
