"use client";

import { useState, useEffect } from "react";
import Link from "next/link";

export default function HomePage() {
  const [veePosition, setVeePosition] = useState({ x: 50, y: 50 });

  useEffect(() => {
    const interval = setInterval(() => {
      setVeePosition({
        x: 50 + Math.sin(Date.now() / 1000) * 10,
        y: 50 + Math.cos(Date.now() / 1500) * 8,
      });
    }, 50);

    return () => clearInterval(interval);
  }, []);

  return (
    <main className="min-h-screen bg-gradient-to-br from-vylo-darker via-vylo-dark to-vylo-darker overflow-hidden relative">
      {/* Animated background grid */}
      <div className="absolute inset-0 bg-[url('/grid.svg')] opacity-10"></div>

      {/* Vee mascot - floating orb */}
      <div
        className="absolute w-32 h-32 rounded-full bg-gradient-to-br from-vylo-accent to-vylo-primary animate-pulse-slow vylo-glow"
        style={{
          left: `${veePosition.x}%`,
          top: `${veePosition.y}%`,
          transform: "translate(-50%, -50%)",
          transition: "all 0.5s cubic-bezier(0.4, 0, 0.2, 1)",
        }}
      >
        {/* Vee's eyes */}
        <div className="absolute top-1/3 left-1/4 w-4 h-4 bg-white rounded-full animate-pulse"></div>
        <div className="absolute top-1/3 right-1/4 w-4 h-4 bg-white rounded-full animate-pulse"></div>
      </div>

      <div className="relative z-10 container mx-auto px-6 py-16">
        {/* Header */}
        <nav className="flex justify-between items-center mb-20">
          <div className="flex items-center gap-3">
            <div className="w-12 h-12 rounded-full bg-gradient-to-br from-vylo-accent to-vylo-primary vylo-glow"></div>
            <h1 className="text-4xl font-black vylo-text-gradient">VYLO</h1>
          </div>
          <div className="flex gap-4">
            <Link href="/login" className="px-6 py-2 rounded-lg border border-vylo-accent/50 hover:border-vylo-primary transition-all">
              Login
            </Link>
            <Link href="/signup" className="vylo-button">
              Start Building
            </Link>
          </div>
        </nav>

        {/* Hero Section */}
        <div className="text-center max-w-5xl mx-auto space-y-8">
          <h2 className="text-7xl font-black leading-tight">
            From <span className="vylo-text-gradient">Vision</span> to{" "}
            <span className="vylo-text-gradient">Launch</span>
            <br />
            <span className="text-5xl text-vylo-primary/80">on Autopilot</span>
          </h2>

          <p className="text-2xl text-gray-400 max-w-3xl mx-auto">
            The AI-powered command center that takes your ideas from concept to deployed software.
            <br />
            <span className="text-vylo-primary">While you sleep. 🚀</span>
          </p>

          <div className="flex justify-center gap-6 pt-8">
            <Link href="/dashboard" className="vylo-button text-xl px-10 py-5">
              Launch Your Project
            </Link>
            <button className="px-10 py-5 rounded-lg border-2 border-vylo-accent/50 hover:border-vylo-primary transition-all text-xl">
              Watch Demo
            </button>
          </div>

          {/* Stats */}
          <div className="grid grid-cols-3 gap-8 pt-16 max-w-3xl mx-auto">
            <div className="vylo-card text-center">
              <div className="text-4xl font-black vylo-text-gradient">5+</div>
              <div className="text-gray-400 mt-2">AI Agents</div>
            </div>
            <div className="vylo-card text-center">
              <div className="text-4xl font-black vylo-text-gradient">24/7</div>
              <div className="text-gray-400 mt-2">Auto-Building</div>
            </div>
            <div className="vylo-card text-center">
              <div className="text-4xl font-black vylo-text-gradient">∞</div>
              <div className="text-gray-400 mt-2">Projects</div>
            </div>
          </div>
        </div>

        {/* Features Grid */}
        <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6 mt-32">
          {[
            { icon: "🎨", title: "Logo & Branding", desc: "AI-generated logos, icons, and brand assets" },
            { icon: "📊", title: "Smart Wireframes", desc: "Interactive prototypes that turn into real code" },
            { icon: "💻", title: "Code Generation", desc: "Claude & GPT-4 writing production-ready code" },
            { icon: "🎯", title: "Marketing Suite", desc: "Copy, graphics, and campaigns on autopilot" },
            { icon: "🤖", title: "Autonomous Agents", desc: "AI teams working 24/7 on your projects" },
            { icon: "🚀", title: "One-Click Deploy", desc: "From idea to live in record time" },
          ].map((feature, i) => (
            <div key={i} className="vylo-card group hover:scale-105">
              <div className="text-5xl mb-4">{feature.icon}</div>
              <h3 className="text-2xl font-bold mb-2 group-hover:vylo-text-gradient transition-all">
                {feature.title}
              </h3>
              <p className="text-gray-400">{feature.desc}</p>
            </div>
          ))}
        </div>
      </div>

      {/* Floating elements */}
      <div className="absolute bottom-10 left-10 w-64 h-64 bg-vylo-accent/20 rounded-full blur-3xl animate-pulse-slow"></div>
      <div className="absolute top-20 right-10 w-96 h-96 bg-vylo-primary/10 rounded-full blur-3xl animate-pulse"></div>
    </main>
  );
}
