import * as internal from "./internal/fiberRefs.js";
/**
 * @since 2.0.0
 * @category symbols
 */
export const FiberRefsSym = internal.FiberRefsSym;
const delete_ = internal.delete_;
export {
/**
 * Deletes the specified `FiberRef` from the `FibterRefs`.
 *
 * @since 2.0.0
 * @category utils
 */
delete_ as delete };
/**
 * Returns a set of each `FiberRef` in this collection.
 *
 * @since 2.0.0
 * @category getters
 */
export const fiberRefs = internal.fiberRefs;
/**
 * Forks this collection of fiber refs as the specified child fiber id. This
 * will potentially modify the value of the fiber refs, as determined by the
 * individual fiber refs that make up the collection.
 *
 * @since 2.0.0
 * @category utils
 */
export const forkAs = internal.forkAs;
/**
 * Gets the value of the specified `FiberRef` in this collection of `FiberRef`
 * values if it exists or `None` otherwise.
 *
 * @since 2.0.0
 * @category getters
 */
export const get = internal.get;
/**
 * Gets the value of the specified `FiberRef` in this collection of `FiberRef`
 * values if it exists or the `initial` value of the `FiberRef` otherwise.
 *
 * @since 2.0.0
 * @category getters
 */
export const getOrDefault = internal.getOrDefault;
/**
 * Joins this collection of fiber refs to the specified collection, as the
 * specified fiber id. This will perform diffing and merging to ensure
 * preservation of maximum information from both child and parent refs.
 *
 * @since 2.0.0
 * @category utils
 */
export const joinAs = internal.joinAs;
/**
 * Set each ref to either its value or its default.
 *
 * @since 2.0.0
 * @category utils
 */
export const setAll = internal.setAll;
/**
 * Updates the value of the specified `FiberRef` using the provided `FiberId`
 *
 * @since 2.0.0
 * @category utils
 */
export const updateAs = internal.updateAs;
/**
 * Updates the values of the specified `FiberRef` & value pairs using the provided `FiberId`
 *
 * @since 2.0.0
 * @category utils
 */
export const updateManyAs = internal.updateManyAs;
/**
 * Note: it will not copy the provided Map, make sure to provide a fresh one.
 *
 * @since 2.0.0
 * @category unsafe
 */
export const unsafeMake = internal.unsafeMake;
/**
 * The empty collection of `FiberRef` values.
 *
 * @category constructors
 * @since 2.0.0
 */
export const empty = internal.empty;
//# sourceMappingURL=FiberRefs.js.map