/**
 * Find the closest matching `quality` in the list of `config.qualities`
 * @param quality the quality prop passed to the image component
 * @param config the "images" configuration from next.config.js
 * @returns the closest matching quality value
 */ export function findClosestQuality(quality, config) {
    const q = quality || 75;
    if (!config?.qualities?.length) {
        return q;
    }
    return config.qualities.reduce((prev, cur)=>Math.abs(cur - q) < Math.abs(prev - q) ? cur : prev, 0);
}

//# sourceMappingURL=find-closest-quality.js.map