/**
 * A union of all keys of T which are not symbols, and where number keys are
 * converted to strings, following the definition of `Object.keys` and
 * `Object.entries`.
 *
 * Inspired and largely copied from [`sindresorhus/ts-extras`](https://github.com/sindresorhus/ts-extras/blob/44f57392c5f027268330771996c4fdf9260b22d6/source/object-keys.ts).
 *
 * @see EnumerableStringKeyedValueOf
 */
type EnumerableStringKeyOf<T> = Required<T> extends Record<infer K, unknown> ? `${Exclude<K, symbol>}` : never;

export type { EnumerableStringKeyOf as E };
